/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.managed;

import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.base.settings.acctinfo.AccountInfo;
import com.ibm.hwmca.base.settings.acctinfo.AcctInfoSaveRestore;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.base.sysinfo.SysInfoTowerUtil;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.base.vpdmgr.VpdData;
import com.ibm.hwmca.base.vpdmgr.VpdManager;
import com.ibm.hwmca.base.vpdmgr.VpdRequestValue;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.cim.CimomInit;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.MOCapabilities;
import com.ibm.hwmca.fw.managed.ProductEngineeringUser;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.sysinfo.SysInfo;
import com.ibm.hwmca.fw.sysinfo.SysInfoData;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.system.IniFileProcessor;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.HThreadGroup;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.PropertiesTool;
import com.ibm.hwmca.fw.util.TaskDefinitionXML;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.snia.wbemcfg.GlobalConfig;

public class BaseTower
extends Tower
implements SysInfo {
    private static final String TRACE_MASKT = "XFRMBT T";
    private static final String TRACE_MASKF = "XFRMBT F";
    private static final String TRACE_MASKD = "XFRMBT D";
    private static final String UTILITY_CLASS_PROPERTIES = "basetower.utilclasses.properties";
    private static final String CIM_PROPERTIES = "cim.properties";
    private static final String START_INI_FILE_NAME = "basestart.ini";
    private static final String STOP_INI_FILE_NAME = "basestop.ini";
    private static final String USERPROFILES_NAME = "com.ibm.hwmca.base.userprof.UserProfilesPluginImpl";
    private static final String USERPROFRESTORE_NAME = "com.ibm.hwmca.base.userprof.UserProfSaveRestore";
    private static final String USER_NAME = "com.ibm.hwmca.fw.managed.User";
    private static final String XML_NAME = "com.ibm.hwmca.fw.util.TaskDefinitionXML";
    private static final String MOMDEBUG_NAME = "com.ibm.hwmca.base.momd.MOMDebugTasklet";
    private static final String AUTOLOGON_NAME = "com.ibm.hwmca.base.settings.autologon.CustomizeAutomaticLogonTasklet";
    private static final String TASKLET_CONTROLLER = "com.ibm.hwmca.fw.tasklet.xport.TaskletController";
    private static BaseTower theTower = null;
    private PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
    private static final String BASE_TOWER_KEY = "com.ibm.hwmca.base.managed.BaseTower";
    public boolean updatingDisabled = false;
    public boolean upgradeInProgress = false;
    public boolean peAccessEnabled = true;
    public boolean autoLogonEnabled = false;
    public boolean snmpEnabled = false;
    private boolean cimEnabled = false;
    public short temporaryFixesActivated = 0;
    public short permanentFixesActivated = 0;
    public String autoLogonUserid = null;
    public String snmpAgentParameters = "";
    public static Thread cimomThread = null;
    private AccountInfo accountInfo = new AccountInfo();
    private static DataRepApp dataRepApp = DataRepApp.getDataRepApp();
    private static String customDataKey = new AcctInfoSaveRestore().getCustomDataKey();
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "BaseTower");
    private static final short ERRID_0480 = 1152;
    private static final short ERRID_0481 = 1153;
    private static final short ERRID_0482 = 1154;
    private static final short ERRID_0483 = 1155;
    private static final short ERRID_0484 = 1156;
    private static final short ERRID_0485 = 1157;
    private static final short ERRID_0486 = 1158;
    private static final short ERRID_0487 = 1159;
    private static final short ERRID_0488 = 1160;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HMC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseTower(String name) {
        super(name);
        Trace.trace(TRACE_MASKT, "-> BaseTower.BaseTower(name=" + name + ")");
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (theTower == null) {
                theTower = this;
                try {
                    BaseTower baseTower = (BaseTower)this.persMgr.read(BASE_TOWER_KEY);
                    if (baseTower != null) {
                        this.updatingDisabled = baseTower.updatingDisabled;
                        this.upgradeInProgress = baseTower.upgradeInProgress;
                        this.peAccessEnabled = baseTower.peAccessEnabled;
                        this.autoLogonEnabled = baseTower.autoLogonEnabled;
                        this.snmpEnabled = baseTower.snmpEnabled;
                        this.temporaryFixesActivated = baseTower.temporaryFixesActivated;
                        this.permanentFixesActivated = baseTower.permanentFixesActivated;
                        this.autoLogonUserid = baseTower.autoLogonUserid;
                        this.snmpAgentParameters = baseTower.snmpAgentParameters;
                        this.accountInfo = baseTower.accountInfo;
                        this.cimEnabled = baseTower.cimEnabled;
                    }
                    this.setUIInfo(new UIInfo(new LocalizableText("com/ibm/hwmca/base/res/text", "tower.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "tower.caption")));
                    this.setPersistent(true);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKD, "Exception caught in BaseTower constructor = " + e);
                    e.printStackTrace();
                    HException hexc = new HException(e);
                    new FrameworkLog(logInfo, 1152, hexc).log();
                }
            } else {
                throw new IllegalStateException("Singleton Base tower already instantiated.");
            }
        }
        Trace.trace(TRACE_MASKT, "<- BaseTower.BaseTower()");
    }

    public BaseTower(PersistentData data) {
        super(null);
        Trace.trace(TRACE_MASKT, "-> BaseTower.BaseTower(data=" + data + ")");
        this.updatingDisabled = ((BaseTowerPersistentData)data).persUpdatingDisabled;
        this.upgradeInProgress = ((BaseTowerPersistentData)data).persUpgradeInProgress;
        this.peAccessEnabled = ((BaseTowerPersistentData)data).persPEAccessEnabled;
        this.autoLogonEnabled = ((BaseTowerPersistentData)data).persAutoLogonEnabled;
        this.snmpEnabled = ((BaseTowerPersistentData)data).persSnmpEnabled;
        this.temporaryFixesActivated = ((BaseTowerPersistentData)data).persTemporaryFixesActivated;
        this.permanentFixesActivated = ((BaseTowerPersistentData)data).persPermanentFixesActivated;
        this.autoLogonUserid = ((BaseTowerPersistentData)data).persAutoLogonUserid;
        this.snmpAgentParameters = ((BaseTowerPersistentData)data).persSnmpAgentParameters;
        this.accountInfo = ((BaseTowerPersistentData)data).persAccountInfo;
        this.setCimEnabled(((BaseTowerPersistentData)data).persCimEnabled);
        Trace.trace(TRACE_MASKT, "<- BaseTower.BaseTower()");
    }

    public static BaseTower getBaseTower() {
        return theTower;
    }

    public void startTower() throws HException {
        HException hexc;
        boolean runningPSeries;
        block25: {
            String fileName;
            Trace.trace(TRACE_MASKT, "-> BaseTower.startTower()");
            runningPSeries = false;
            byte[] bCpxStatus = SimServer.getSimServer().readSim(5);
            if (bCpxStatus[0] == 4) {
                runningPSeries = true;
            }
            try {
                fileName = BaseFileControl.getFilePath(UTILITY_CLASS_PROPERTIES) + UTILITY_CLASS_PROPERTIES;
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKD, "Error in getting file path");
                fileName = UTILITY_CLASS_PROPERTIES;
            }
            Map m = PropertiesTool.readCustomProperties(fileName);
            if (m != null) {
                Iterator i = m.keySet().iterator();
                while (i.hasNext()) {
                    Class key = (Class)i.next();
                    Object value = m.get(key);
                    BaseTower.addClassInterfaceImpl(this.getClass(), key, value);
                }
            }
            try {
                BaseFileControl.makeFilePath("domainsocket");
                String computerName = NetworkSettings.getNetworkSettings().getNetworkInfo().getComputerName();
                byte[] nauByte = SimServer.getSimServer().readSim(7);
                if (nauByte == null || nauByte[0] == 0) {
                    String hostName = null;
                    String property = System.getProperty("DEVELOPMENT_SYSTEM");
                    if (property != null && property.equals("YES")) {
                        hostName = InetAddress.getLocalHost().getHostName();
                        Trace.trace(TRACE_MASKF, "Set NETID/NAU to local host name.");
                    } else if (bCpxStatus[0] == 4) {
                        hostName = computerName;
                        Trace.trace(TRACE_MASKF, "Leave hostname unchanged: [" + hostName + "]");
                    } else {
                        HException hexc2;
                        if (bCpxStatus[0] == 1) {
                            try {
                                VpdData vpdData = new VpdData(VpdRequestValue.CONFIG_REQUEST);
                                VpdManager Vpd = VpdManager.getVpdManager();
                                vpdData = Vpd.callVpdManager(vpdData);
                                String serialNumber = vpdData.getVpdConfigurationExistData().getMachineSerial();
                                Trace.trace(TRACE_MASKD, "Machine serial = " + serialNumber);
                                hostName = "P" + serialNumber.substring(serialNumber.length() - 1 - 7, serialNumber.length() - 1);
                                Trace.trace(TRACE_MASKF, "Set NAU to " + hostName + ".");
                            }
                            catch (Exception exc) {
                                Trace.trace(TRACE_MASKF, "Exception " + exc + " from vpd.");
                                Trace.trace(TRACE_MASKF, "Set NAU to P1020304.");
                                hexc2 = new HException(exc);
                                new FrameworkLog(logInfo, 1153, hexc2).log();
                                hostName = "P1020304";
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "Set NAU to HMC1.");
                            hostName = "HMC1";
                        }
                        try {
                            NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
                            networkInfo.setComputerName(hostName);
                            NetworkSettings.getNetworkSettings().applyNetworkSettings(networkInfo);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            hexc2 = new HException(e);
                            new FrameworkLog(logInfo, 1154, hexc2).log();
                        }
                    }
                    this.setHostNameInSim(hostName);
                    break block25;
                }
                if (nauByte.length > 0) {
                    int len;
                    for (len = 0; nauByte[len] != 0 && len < nauByte.length; ++len) {
                    }
                    String nau = new String(nauByte, 0, len);
                    Trace.trace(TRACE_MASKF, "No need to set NAU, NAU already set to " + nau + ".");
                }
                if (computerName != null && computerName.length() > 0) {
                    this.setHostNameInSim(computerName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                hexc = new HException(e);
                new FrameworkLog(logInfo, 1155, hexc).log();
            }
        }
        TaskDefinitionXML.add(TOWER_PLUGINS_PATH + this.getXMLFile());
        if (!runningPSeries) {
            ProductEngineeringUser.getProductEngineeringUser();
        }
        mom.addSkipPermission(this.getObjectId().getClassId());
        mom.addFullAccessMethod(USERPROFILES_NAME, "getProfilesInventory");
        mom.addFullAccessMethod(USERPROFILES_NAME, "getProfilesObj");
        mom.addFullAccessMethod(USERPROFILES_NAME, "addUser");
        mom.addFullAccessMethod(USERPROFILES_NAME, "addRole");
        mom.addFullAccessMethod(USERPROFRESTORE_NAME, "getSaveableData");
        mom.addFullAccessMethod(USERPROFRESTORE_NAME, "processRoles");
        mom.addFullAccessMethod(USERPROFRESTORE_NAME, "processUsers");
        mom.addFullAccessMethod(USER_NAME, "getPermittedRoles");
        mom.addFullAccessMethod(XML_NAME, "createUserRoles");
        mom.addFullAccessMethod(XML_NAME, "updateChildrenOfRole");
        mom.addFullAccessMethod(MOMDEBUG_NAME, "createRootNodes");
        mom.addFullAccessMethod(AUTOLOGON_NAME, "getAllUsers");
        try {
            IniFileProcessor.runClasses(START_INI_FILE_NAME, "BaseTower INI");
        }
        catch (Exception e) {
            e.printStackTrace();
            hexc = new HException(e);
            new FrameworkLog(logInfo, 1156, hexc).log();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            hexc = new HException(e);
            new FrameworkLog(logInfo, 1157, hexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- BaseTower.startTower()");
    }

    public void stopTower() throws HException {
        Trace.trace(TRACE_MASKT, "-> BaseTower.stopTower()");
        try {
            IniFileProcessor.runClasses(STOP_INI_FILE_NAME, "BaseTower INI");
        }
        catch (Exception e) {
            e.printStackTrace();
            HException hexc = new HException(e);
            new FrameworkLog(logInfo, 1158, hexc).log();
        }
        Trace.trace(TRACE_MASKT, "-> BaseTower.stopTower()");
    }

    protected String getBooksXMLFileName() {
        return TOWER_PLUGINS_PATH + this.getXMLFile();
    }

    public boolean isPhoneServer() {
        RemoteSupportFacility consoleRsf = RsfManager.getRsfManager().getConsoleRsf();
        if (consoleRsf != null) {
            return consoleRsf.isCallHomeServerEnabled();
        }
        return false;
    }

    public void setPhoneServer(boolean value) {
        RemoteSupportFacility consoleRsf = RsfManager.getRsfManager().getConsoleRsf();
        if (consoleRsf != null) {
            consoleRsf.setCallHomeServerEnabled(value);
        }
    }

    public boolean isUpdatingDisabled() {
        Trace.trace(TRACE_MASKF, "<> BaseTower.isUpdatingDisabled()");
        return this.updatingDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdatingDisabled(boolean value) {
        Trace.trace(TRACE_MASKF, "-> BaseTower.setUpdatingDisabled()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.updatingDisabled = value;
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- BaseTower.setUpdatingDisabled()");
    }

    public boolean isUpgradeInProgress() {
        Trace.trace(TRACE_MASKF, "<> BaseTower.isUpgradeInProgress(): " + this.upgradeInProgress);
        return this.upgradeInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgradeInProgress(boolean value) {
        Trace.trace(TRACE_MASKF, "-> BaseTower.setUpgradeInProgress()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.upgradeInProgress = value;
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- BaseTower.setUpgradeInProgress()");
    }

    public boolean isPEAccessEnabled() {
        Trace.trace(TRACE_MASKF, "<> BaseTower.isPEAccessEnabled()");
        return this.peAccessEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPEAccess(boolean peaccess) {
        Trace.trace(TRACE_MASKF, "-> BaseTower.setPEAccess()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.peAccessEnabled = peaccess;
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKF, "<- BaseTower.setPSAccess()");
    }

    public boolean isAutoLogonEnabled() {
        Trace.trace(TRACE_MASKD, "<> BaseTower.isAutoLogonEnabled()");
        return this.autoLogonEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoLogon(boolean autologon) {
        Trace.trace(TRACE_MASKD, "-> BaseTower.setAutoLogon()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.autoLogonEnabled = autologon;
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKD, "<- BaseTower.setAutoLogon()");
    }

    public boolean isSnmpEnabled() {
        Trace.trace(TRACE_MASKT, "<> BaseTower.isSnmpEnabled()");
        return this.snmpEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSnmpEnabled(boolean value) {
        Trace.trace(TRACE_MASKT, "-> BaseTower.setSnmpEnabled()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.snmpEnabled = value;
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- BaseTower.setSnmpEnabled()");
    }

    public boolean isCimEnabled() {
        Trace.trace(TRACE_MASKF, "<> BaseTower.isCimEnabled()");
        return this.cimEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCimEnabled(boolean value) {
        Trace.trace(TRACE_MASKT, "-> BaseTower.setCimEnabled(value=" + value + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.cimEnabled = value;
        }
        this.autoPersist();
        if (value && cimomThread == null) {
            Trace.trace(TRACE_MASKF, "Starting the CIMOM");
            try {
                String configFilePath = BaseFileControl.getFilePath(CIM_PROPERTIES);
                String configFileName = configFilePath + CIM_PROPERTIES;
                if (configFileName != null) {
                    Trace.trace(TRACE_MASKF, "Using config file: " + configFileName);
                    System.setProperty("org.snia.wbem.cimom.properties", configFileName);
                    Trace.trace(TRACE_MASKF, "tempPath=" + GlobalConfig.tempPath);
                    GlobalConfig.tempPath = configFilePath + "cimom/";
                    new File(GlobalConfig.tempPath).mkdirs();
                    Trace.trace(TRACE_MASKF, "CIMOM temp directory: " + GlobalConfig.tempPath);
                    String[] cimomArgs = new String[]{};
                    cimomThread = HThreadGroup.defaultThreadGroup().createThread(new CimomInit(), "CIMOM");
                    cimomThread.start();
                }
            }
            catch (HException exc) {
                Trace.trace(TRACE_MASKF, "Error locating CIM config file");
                exc.printStackTrace();
                new FrameworkLog(logInfo, 1159, exc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- BaseTower.setCimEnabled()");
    }

    public short getTemporaryFixesActivated() {
        Trace.trace(TRACE_MASKD, "<> BaseTower.getTemporaryFixesActivated()");
        return this.temporaryFixesActivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemporaryFixesActivated(short value) {
        Trace.trace(TRACE_MASKD, "-> BaseTower.setTemporaryFixesActivated()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.temporaryFixesActivated = value;
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKD, "-> BaseTower.setTemporaryFixesActivated()");
    }

    public short getPermanentFixesActivated() {
        Trace.trace(TRACE_MASKD, "<> BaseTower.getPermanentFixesActivated()");
        return this.permanentFixesActivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermanentFixesActivated(short value) {
        Trace.trace(TRACE_MASKD, "-> BaseTower.setPermanentFixesActivated()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.permanentFixesActivated = value;
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKD, "-> BaseTower.setPermanentFixesActivated()");
    }

    public String getAutoLogonUserid() {
        Trace.trace(TRACE_MASKD, "<> BaseTower.getAutoLogonUserid()");
        return this.autoLogonUserid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoLogonUserid(String userid) {
        Trace.trace(TRACE_MASKD, "-> BaseTower.setAutoLogonUserid()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.autoLogonUserid = userid;
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKD, "<- BaseTower.setAutoLogonUserid()");
    }

    public String getSnmpAgentParameters() {
        Trace.trace(TRACE_MASKT, "<> BaseTower.getSnmpAgentParameters()");
        return this.snmpAgentParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSnmpAgentParameters(String params) {
        Trace.trace(TRACE_MASKT, "-> BaseTower.setSnmpAgentParameters()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.snmpAgentParameters = params;
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- BaseTower.setSnmpAgentParameters()");
    }

    public String getDomainName() throws HException {
        byte[] simdata = SimServer.getSimServer().readSim(18);
        String retval = null;
        if (simdata != null) {
            int len = 0;
            for (int i = 0; i < simdata.length && simdata[i] != 0; ++i) {
                ++len;
            }
            retval = len > 0 ? new String(simdata, 0, len) : "";
        }
        if (retval == null || retval.trim().equals("")) {
            retval = "$$FOO$$";
        }
        return retval;
    }

    public byte[] getDomainPassword() throws HException {
        byte[] simdata = SimServer.getSimServer().readSim(17);
        String retval = null;
        if (simdata != null) {
            int len = 0;
            for (int i = 0; i < simdata.length && simdata[i] != 0; ++i) {
                ++len;
            }
            retval = len > 0 ? new String(simdata, 0, len) : "";
        }
        if (retval == null || retval.trim().equals("")) {
            retval = "BAR";
        }
        return CommonSystem.getCommonSystem().hashPassword(retval);
    }

    public List getNetworkInterfaceInformation() {
        return NetworkSettings.getNetworkSettings().getNetworkInterfaceInfo();
    }

    public void setNetworkInterfaceInformation(List networkIfs) {
        NetworkSettings.getNetworkSettings().setNetworkInterfaceInfo(networkIfs);
    }

    public NetworkInfo getNetworkSettings() {
        return NetworkSettings.getNetworkSettings().getNetworkInfo();
    }

    public void setNetworkSettings(NetworkInfo networkInfo) {
        NetworkSettings.getNetworkSettings().setNetworkInfo(networkInfo);
        NetworkSettings.getNetworkSettings().updateConfigFiles();
    }

    public AccountInfo getAccountSettings() {
        Trace.trace(TRACE_MASKT, "<> BaseTower.getAccountSettings()");
        return this.accountInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccountSettings(AccountInfo accountInfo) {
        Trace.trace(TRACE_MASKD, "-> BaseTower.setAccountSettings()");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            this.accountInfo = accountInfo;
            if (dataRepApp.isDataRepEnabled() && !dataRepApp.isUpdateInProgress()) {
                dataRepApp.updateCustomDataLevel(customDataKey);
            }
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKD, "<- BaseTower.setAccountSettings()");
    }

    public boolean isUpgradeData() {
        return true;
    }

    public PersistentData getPersistentData() {
        BaseTowerPersistentData persData = new BaseTowerPersistentData();
        persData.persUpdatingDisabled = this.updatingDisabled;
        persData.persUpgradeInProgress = this.upgradeInProgress;
        persData.persPEAccessEnabled = this.peAccessEnabled;
        persData.persSnmpEnabled = this.snmpEnabled;
        persData.persAutoLogonEnabled = this.autoLogonEnabled;
        persData.persTemporaryFixesActivated = this.temporaryFixesActivated;
        persData.persPermanentFixesActivated = this.permanentFixesActivated;
        persData.persAutoLogonUserid = this.autoLogonUserid;
        persData.persSnmpAgentParameters = this.snmpAgentParameters;
        persData.persAccountInfo = this.accountInfo;
        persData.persCimEnabled = this.cimEnabled;
        return persData;
    }

    public String getPersistKey() {
        return BASE_TOWER_KEY;
    }

    public SysInfoData getSysInfoData() throws HException {
        Trace.trace(TRACE_MASKT, "-> getSysInfoData");
        SysInfoTowerUtil towerUtil = new SysInfoTowerUtil(this);
        return towerUtil.getSysInfoData();
    }

    public String getSysInfoTaskletName() throws HException {
        Trace.trace(TRACE_MASKT, "<-> getSysInfoTaskletName");
        String taskletName = "com.ibm.hwmca.base.sysinfo.SysInfoEcTasklet";
        Trace.trace(TRACE_MASKF, "BaseTower TaskletName = " + taskletName);
        return taskletName;
    }

    public void setHostNameInSim(String hostName) {
        Trace.trace(TRACE_MASKF, "-> BaseTower.setHostNameInSim(" + hostName + ")");
        try {
            String netid = "ZZZZZZZZ";
            String nau = "";
            int index = hostName.indexOf(46);
            if (index != -1) {
                hostName = hostName.substring(0, index);
            }
            if (hostName.length() <= 8) {
                nau = hostName;
            } else {
                nau = hostName.substring(hostName.length() - 8, hostName.length());
                String tempNetid = hostName.substring(0, hostName.length() - 8);
                netid = tempNetid.concat(netid).substring(0, 8);
            }
            byte[] nulls = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
            nau = nau.toUpperCase() + new String(nulls);
            nau = nau.substring(0, 9);
            Trace.trace(TRACE_MASKF, "setting Base PU Name to [" + nau + "]");
            SimServer.getSimServer().writeSim(7, nau.getBytes());
            netid = netid.toUpperCase() + new String(nulls);
            netid = netid.substring(0, 9);
            Trace.trace(TRACE_MASKF, "setting Base NETNAME to [" + netid + "]");
            SimServer.getSimServer().writeSim(6, netid.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            HException hexc = new HException(e);
            new FrameworkLog(logInfo, 1160, hexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- BaseTower.setHostNameInSim(" + hostName + ")");
    }

    public MOCapabilities[] getMOCapabilities() {
        Trace.trace(TRACE_MASKT, "-> BaseTower.getMOCapabilities()");
        MOCapabilities[] result = new MOCapabilities[]{new MOCapabilities(new ClassId(class$com$ibm$hwmca$fw$managed$HMC == null ? (class$com$ibm$hwmca$fw$managed$HMC = BaseTower.class$("com.ibm.hwmca.fw.managed.HMC")) : class$com$ibm$hwmca$fw$managed$HMC), new String[]{"HW_MESSAGES_CAPABILITIES"})};
        Trace.trace(TRACE_MASKT, "<- BaseTower.getMOCapabilities()");
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BaseTowerPersistentData
    implements PersistentData {
        private static final long serialVersionUID = 1L;
        public boolean persUpdatingDisabled;
        public boolean persUpgradeInProgress;
        public boolean persPEAccessEnabled;
        public boolean persAutoLogonEnabled;
        public boolean persSnmpEnabled;
        public short persTemporaryFixesActivated;
        public short persPermanentFixesActivated;
        public String persAutoLogonUserid;
        public String persSnmpAgentParameters = "";
        private AccountInfo persAccountInfo;
        private boolean persCimEnabled;

        private BaseTowerPersistentData() {
        }
    }
}

